capture program drop appendContextVar
program define appendContextVar

/*
Use Date or Start_date
*/

version 13.1
*! version 1.0 January 22, 2016

syntax , table(string)


display ""
display "Start of the program APPEND CONTEXTUAL VARIABLES"
which appendContextVar
display ""

display "	Part 1: Checking that all files are available and appending Types to the METADATA table"

qui capture use `table', clear
	if _rc!=0{
	display "	File `table'.dta not found."
	display "	The program APPEND CONTEXTUAL VARIABLES was stopped."
	qui exit
	}

qui capture use INDIV_CONTEXT.dta, clear
	if _rc!=0{
	display "	File INDIV_CONTEXT.dta not found."
	display "	The program APPEND CONTEXTUAL VARIABLES was stopped."
	qui exit
	}	
	
qui capture import excel `table'_SELECT.xls, sheet("Sheet1") firstrow clear
	if _rc!=0{
	display "	File `table'_SELECT.xls not found. Run the program selectType to create it and select the desired Types."
	display "	The program APPEND CONTEXTUAL VARIABLES was stopped."
	qui exit
	 }


qui capture use VarSetup.dta, clear
	if _rc!=0{
	display "	File VarSetup.dta not found. Run the program IDSextended to create it."
	display "	The program APPEND CONTEXTUAL VARIABLES was stopped."
	qui exit
	}

qui capture use Chronicle.dta, clear
	if _rc!=0{
	display "	File Chronicle.dta not found. Run the program IDSextended to create it."
	display "	The program APPEND CONTEXTUAL VARIABLES was stopped."
	qui exit
	}	


	
display "	Part 2: Appending selected Types to the VarSetup table"

qui{
import excel `table'_SELECT.xls, sheet("Sheet1") firstrow clear
keep Type Select Duration
tempfile selected
save `selected'
}
	
qui{	
use `selected', clear	
keep if Select==1
keep Type Duration
gen Transition="Start"
append using VarSetup.dta
save VarSetup.dta, replace
}




display "	Part 3: Selecting dates of change in contextual variables"
qui {


use `table', clear
foreach varName in End_day End_month End_year Start_day Start_month Start_year Year Month Day DayFrac{
capture confirm variable `varName'
	if _rc!=0{
	gen `varName' = .
	}
}
save `table',replace




use `table', clear

keep Id_C Type Value Year Month Day DayFrac End_day End_month End_year Start_day Start_month Start_year 

keep if Start_day!=. & Day==.
drop Day Month Year
rename Start_day Day
rename Start_month Month
rename Start_year Year
drop End_day End_month End_year
tempfile spellData

capture duplicates drop 
save `spellData', replace

use `table', clear
keep if Start_day!=. & Day==.
drop Day Month Year
rename End_day Day
rename End_month Month
rename End_year Year
drop Start_day Start_month Start_year

capture duplicates drop 

merge 1:1 Id_C Type Day Month Year DayFrac using `spellData'


keep if _merge==1
drop _merge
replace Value = "-1"

append using `spellData'

tempfile spellData1
save `spellData1', replace


use `table', clear
keep if Start_day==.
append using `spellData1'

drop Start_day Start_month Start_year End_day End_month End_year

merge m:1 Type using `selected', noreport nogen
tempfile CSel
save `CSel'

gen temp = (Select==1)
egen temp1 = sum(temp)
keep if _n==1
keep temp1
local temp2=temp1 
}

if `temp2'==0{
	display ""
	display "	No Types were selected in the file `table'_SELECT.xls."
	display "	The program APPEND CONTEXTUAL VARIABLES was stopped. Select Types and restart the program."
	qui exit
}


qui{
use `CSel',clear
keep if Select==1

gen Date = mdy(Month,Day,Year)
format Date %td
drop Month Day Year

tempfile Contextselected
save `Contextselected'

}


qui{
*Dates of change in contextual variables
use `Contextselected', clear
drop Select Duration
keep if Date!=.
tempfile DateChanges
save `DateChanges', replace
}


display "	Part 4: Assigning values of contextual variables to the individual"

qui{
****Dates of change occuring on or after the individual enters the context
use INDIV_CONTEXT.dta,clear
gen Start_date =mdy(Start_month, Start_day, Start_year)
gen End_date = mdy(End_month,End_day,End_year)
format Start_date End_date %td
drop Start_day Start_month Start_year End_day End_month End_year
capture drop Day Month Year

tempfile indivcon
save `indivcon'

joinby Id_C using `DateChanges'

keep if Date>=Start_date & Date<End_date
keep Id_I Type Value Date Id_C
tempfile Indiv_contextualVar
save `Indiv_contextualVar'
}




****Individual start dates occuring after start date of context var

*Context variables start and end dates
qui{
use `Contextselected', clear
keep if Duration=="Continuous"
drop Select Duration
sort Id_C Type Date 
gen d1 = Date
gen d2 = Date[_n+1] if Id_C==Id_C[_n+1] & Type==Type[_n+1]
format d1 d2 %td
drop Date
tempfile ForStartDate
save `ForStartDate'
}

*List of types per context where Duration is Continuous
qui{
use `selected', clear	
keep if Select==1
keep if Duration=="Continuous"
keep Type
gen mergevar=1
tempfile selectTypes
save `selectTypes'
}

*Merge context change dates occuring before first entry into the context
qui{
use `indivcon',clear
sort Id_I Id_C Start_date End_date
by Id_I Id_C: gen row=_n
keep if row==1
drop row
tempfile inddates_step1
save `inddates_step1'

use `indivcon',clear
sort Id_I Id_C Start_date End_date
keep if Start_date!=End_date[_n-1] & Id_I==Id_I[_n-1] & Id_C==Id_C[_n-1]
append using `inddates_step1'
tempfile firstDate
save `firstDate'

use `firstDate'
gen mergevar = 1
joinby mergevar using `selectTypes'
drop mergevar

joinby Id_C Type using `ForStartDate'
keep if (Start_date>d1 & Start_date<d2) | (Start_date>d1 & d2==.)
keep Id_I Type Value Start_date Id_C
rename Start_date Date
append using `Indiv_contextualVar'
tempfile Indiv_contextualVar1
save `Indiv_contextualVar1'
}


****Emtpy value on first date in context
qui{
use `firstDate'
gen mergevar = 1
joinby mergevar using `selectTypes'
drop mergevar
drop End_date
rename Start_date Date
merge 1:1 Id_I Id_C Type Date using `Indiv_contextualVar1'
keep if _merge==1
drop _merge
replace Value ="NoValue"
append using `Indiv_contextualVar1'
tempfile Indiv_contextualVar2
save `Indiv_contextualVar2'
}

display "	Part 5: Appending contextual variables to EventChronicle.dta"
qui{
use `Indiv_contextualVar2', clear
drop Id_C Id_D
sort Id_I Type Date
gen Day = day(Date)
gen Month=month(Date)
gen Year=year(Date)
drop Date

tempfile Indiv_contextualVar3
save `Indiv_contextualVar3'

use Chronicle.dta, clear
append using `Indiv_contextualVar3'
save Chronicle.dta,replace
}

display ""
display "All selected contextual variables have been added to Chronicle.dta"
display "Selected types have been added to VarSetup.dta"
display ""
display "End of the program APPEND CONTEXTUAL VARIABLES"


end
